/*
GMCOM.CS
Copyright  9/15/04 by Greg Wittmeyer
All Rights Reserved

This example demonstrates how to use GMCOM.DLL from a C# program.
*/


using System;
using System.Runtime.InteropServices;


// Gammadyne Mailer engine
[ComImport, Guid("80FA9B80-382E-4A30-A4F6-0FE56CA9B3F0")]
class GMEngine
{
}


// engine interface
[ComImport, Guid("2FFE7577-907D-4370-840B-2CF1D5C11912"),
InterfaceType(ComInterfaceType.InterfaceIsDual)]

interface GMEngineIfx
{
	unsafe int load_mem(sbyte *data);
	unsafe int load_file(sbyte *filename);
	int send_messages();
	sbyte *get_error_description();
	sbyte *get_summary();
	int get_successful_sends();
	int get_failed_sends();
	int load_mem_w([In, MarshalAs(UnmanagedType.BStr)] string data);
	sbyte *get_stats();
	void reserved1();
	void reserved2();
	int load_file_w([In, MarshalAs(UnmanagedType.BStr)] string filename);
	string get_error_description2();
}
	

namespace CSharp
{
	/// <summary>
	/// Summary description for Class1.
	/// </summary>
	class Class1
	{
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		unsafe static void Main(string[] args)
		{
			// create the interface to GMCOM.DLL
			GMEngine gmc = new GMEngine();
			GMEngineIfx gm = (GMEngineIfx)gmc;

			// load the psuedo-project
			String filename = "C:\\G\\MMail\\at-com.txt";
			if(gm.load_file_w(filename) != 1)
			{
				System.Console.WriteLine("Failed to open project.");
				return;
			}

			System.Console.WriteLine("Load succeeded");

			// send the messages
			int status = gm.send_messages();

			// report the results
			Console.WriteLine("Send status: " + status);
			Console.WriteLine("Successes: " + gm.get_successful_sends());
			Console.WriteLine("Failures: " + gm.get_failed_sends());
			Console.WriteLine("Error: " + new String(gm.get_error_description()));
			Console.WriteLine("Error2: " + gm.get_error_description2());
			Console.WriteLine("Summary: " + new String(gm.get_summary()));
			Console.WriteLine("Stats: " + new String(gm.get_stats()));
			Console.WriteLine("Exiting");
		}
	}
}
